// Listing 9-5

public class Listing9_5
{
   public static void main(String[] args)
   {
      // Tablica liczb typu int
      int[] numbers = { 4, 6, 1, 3, 5, 2 };

      // Licznik pętli
      int index;
      
      // Wyświetlamy elementy tablicy w pierwotnej kolejności
      System.out.println("Pierwotna kolejność:");
      for (index = 0; index < numbers.length; index++)
         System.out.println(numbers[index]);
      
      // Sortujemy tablicę
      selectionSort(numbers);

      // Wstawiamy pustą linię
      System.out.println();

      // Wyświetlamy posortowaną tablicę
      System.out.println("Posortowane liczby:");
      for (index = 0; index < numbers.length; index++)
         System.out.println(numbers[index]);
   }

   //   Metoda selectionSort wykonuje na tablicy liczb int
   //   sortowanie przez wybieranie; elementy zostaną posortowane w koleności rosnącej
   
   public static void selectionSort(int[] array)
   {
      int startScan;   // Początkowy indeks
      int index;       // Licznik, w którym zapiszemy indeks
      int minIndex;    // Indeks elementu o najmniejszej wartości znajdującego się w przeszukiwanym fragmencie tablicy
      int minValue;    // Najmniejszy element w przeszukiwanym fragmencie tablicy

      // Pętla zewnętrzna wykonuje iterację dla każdego elementu tablicy
      // z wyjątkiem ostatniego. Zmienna startScan oznacza indeks,
      // od którego należy rozpocząć przeszukiwanie
      for (startScan = 0; startScan < (array.length-1); startScan++)
      {
         // Na początku zakładamy, że to pierwszy element
         // ma najniższą wartość
         minIndex = startScan;
         minValue = array[startScan];
         
         // Przeszukujemy tablicę, zaczynając od drugiego elementu
         // w przeszukiwanym obszarze. Poszukujemy w tym obszarze
         // elementu o najmniejszej wartości 
         for(index = startScan + 1; index < array.length; index++)
         {
            if (array[index] < minValue)
            {
               minValue = array[index];
               minIndex = index;
            }
         }

         // Zamieniamy miejscami element, w którym jest zapisana najmniejsza wartość,
         // i pierwszy element w przeszukiwanym obszarze
         array[minIndex] = array[startScan];
         array[startScan] = minValue;
      }
   }
}